'use client'

import Link from 'next/link'
import { useState } from 'react'
import { Menu, X, GraduationCap, User } from 'lucide-react'

export default function Navbar() {
  const [isOpen, setIsOpen] = useState(false)

  const menuItems = [
    { name: 'Home', href: '/' },
    { name: 'Profil', href: '#profil' },
    { name: 'Guru', href: '#guru' },
    { name: 'Siswa', href: '#siswa' },
    { name: 'Rekap Siswa', href: '#rekap' },
    { name: 'Katrol Nilai', href: '#katrol' },
    { name: 'Catatan Wali Kelas', href: '#catatan' },
    { name: 'Download', href: '#download' },
    { name: 'Login', href: '#login', special: true },
  ]

  return (
    <nav className="bg-gradient-to-r from-yellow-400 via-yellow-400 to-green-500 shadow-lg sticky top-0 z-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between items-center h-16">
          {/* Logo */}
          <div className="flex items-center">
            <Link href="/" className="flex items-center space-x-2 text-white hover:text-yellow-100 transition-colors">
              <GraduationCap className="h-8 w-8" />
              <span className="font-bold text-xl">Sekolah Unggulan</span>
            </Link>
          </div>

          {/* Desktop Menu */}
          <div className="hidden md:flex items-center space-x-4">
            {menuItems.slice(0, -1).map((item) => (
              <Link
                key={item.name}
                href={item.href}
                className="text-white hover:bg-white/20 px-3 py-2 rounded-md text-sm font-medium transition-all duration-200"
              >
                {item.name}
              </Link>
            ))}
            <Link
              href="#login"
              className="flex items-center space-x-2 bg-white text-green-600 hover:bg-yellow-50 px-4 py-2 rounded-md text-sm font-bold shadow-md transition-all duration-200"
            >
              <User className="h-4 w-4" />
              <span>Login</span>
            </Link>
          </div>

          {/* Mobile menu button */}
          <div className="md:hidden">
            <button
              onClick={() => setIsOpen(!isOpen)}
              className="text-white hover:bg-white/20 p-2 rounded-md inline-flex items-center justify-center transition-all duration-200"
              aria-expanded="false"
            >
              <span className="sr-only">Open main menu</span>
              {isOpen ? <X className="h-6 w-6" /> : <Menu className="h-6 w-6" />}
            </button>
          </div>
        </div>
      </div>

      {/* Mobile Menu */}
      {isOpen && (
        <div className="md:hidden bg-white/95 backdrop-blur-sm border-t border-green-500">
          <div className="px-2 pt-2 pb-3 space-y-1">
            {menuItems.map((item) => (
              <Link
                key={item.name}
                href={item.href}
                className={`${
                  item.special
                    ? 'bg-green-500 text-white hover:bg-green-600'
                    : 'text-gray-700 hover:bg-green-50'
                } block px-3 py-2 rounded-md text-base font-medium transition-all duration-200`}
                onClick={() => setIsOpen(false)}
              >
                {item.name}
              </Link>
            ))}
          </div>
        </div>
      )}
    </nav>
  )
}
