import { GraduationCap, Mail, Phone, MapPin } from 'lucide-react'

export default function Footer() {
  return (
    <footer className="bg-gradient-to-r from-green-600 to-green-500 text-white mt-auto">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {/* Column 1: Tentang */}
          <div>
            <div className="flex items-center space-x-2 mb-4">
              <GraduationCap className="h-6 w-6 text-yellow-400" />
              <h3 className="text-lg font-bold">Sekolah Unggulan</h3>
            </div>
            <p className="text-green-100 text-sm">
              Mewujudkan generasi berkarakter, cerdas, dan berprestasi.
              Lembaga pendidikan yang berkomitmen memberikan pelayanan terbaik.
            </p>
          </div>

          {/* Column 2: Kontak */}
          <div>
            <h3 className="text-lg font-bold mb-4 text-yellow-400">Hubungi Kami</h3>
            <ul className="space-y-2 text-sm text-green-100">
              <li className="flex items-start space-x-2">
                <MapPin className="h-4 w-4 mt-0.5 flex-shrink-0" />
                <span>Jl. Pendidikan No. 123, Kota, Indonesia</span>
              </li>
              <li className="flex items-center space-x-2">
                <Phone className="h-4 w-4 flex-shrink-0" />
                <span>(021) 1234-5678</span>
              </li>
              <li className="flex items-center space-x-2">
                <Mail className="h-4 w-4 flex-shrink-0" />
                <span>info@sekolahunggulan.sch.id</span>
              </li>
            </ul>
          </div>

          {/* Column 3: Copyright */}
          <div>
            <h3 className="text-lg font-bold mb-4 text-yellow-400">Copyright</h3>
            <p className="text-sm text-green-100">
              © {new Date().getFullYear()} Sekolah Unggulan.<br />
              Seluruh hak cipta dilindungi undang-undang.
            </p>
          </div>
        </div>

        {/* Bottom bar */}
        <div className="border-t border-green-400 mt-8 pt-4 text-center text-sm text-green-100">
          <p>Sistem Informasi Akademik - Dibuat dengan Next.js 16</p>
        </div>
      </div>
    </footer>
  )
}
