'use client'

import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card'
import { Button } from '@/components/ui/button'
import { Input } from '@/components/ui/input'
import { GraduationCap, Users, Award, BookOpen, TrendingUp, Clock } from 'lucide-react'
import Link from 'next/link'

export default function Home() {
  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-yellow-400 via-green-500 to-green-600 py-20 px-4">
        <div className="max-w-7xl mx-auto">
          <div className="text-center text-white">
            <GraduationCap className="h-24 w-24 mx-auto mb-6 animate-bounce" />
            <h1 className="text-4xl md:text-6xl font-bold mb-6">
              Selamat Datang di Sekolah Unggulan
            </h1>
            <p className="text-xl md:text-2xl mb-8 max-w-3xl mx-auto">
              Mewujudkan Generasi Berkarakter, Cerdas, dan Berprestasi
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link href="#profil">
                <Button size="lg" className="bg-white text-green-600 hover:bg-yellow-50 text-lg px-8">
                  Pelajari Lebih Lanjut
                </Button>
              </Link>
              <Link href="#login">
                <Button size="lg" variant="outline" className="bg-transparent text-white border-2 border-white hover:bg-white/20 text-lg px-8">
                  Login Admin
                </Button>
              </Link>
            </div>
          </div>
        </div>
      </section>

      {/* Sambutan Kepala Sekolah */}
      <section className="py-16 px-4 bg-gray-50">
        <div className="max-w-7xl mx-auto">
          <Card className="shadow-xl border-2 border-green-100">
            <CardHeader>
              <CardTitle className="text-3xl font-bold text-green-700">Sambutan Kepala Sekolah</CardTitle>
            </CardHeader>
            <CardContent className="prose max-w-none">
              <div className="flex flex-col md:flex-row gap-8 items-start">
                <div className="md:w-1/3">
                  <div className="bg-gradient-to-br from-green-500 to-green-600 rounded-lg p-8 text-white text-center">
                    <div className="text-6xl font-bold mb-4">"</div>
                    <p className="text-lg italic">Assalamu'alaikum Warahmatullahi Wabarakatuh</p>
                  </div>
                </div>
                <div className="md:w-2/3">
                  <p className="text-gray-700 leading-relaxed mb-4">
                    Puji syukur kita panjatkan ke hadirat Allah SWT. Selamat datang di website resmi Sekolah Unggulan. 
                    Website ini hadir sebagai sarana informasi dan komunikasi antara sekolah, siswa, orang tua, dan masyarakat luas.
                  </p>
                  <p className="text-gray-700 leading-relaxed mb-4">
                    Kami berkomitmen untuk memberikan pendidikan berkualitas yang menggabungkan akademik, karakter, dan keahlian, 
                    guna mencetak generasi unggul yang siap menghadapi tantangan global.
                  </p>
                  <p className="text-gray-700 leading-relaxed">
                    Mari bersama-sama membangun masa depan gemilang bagi bangsa dan negara.
                  </p>
                  <div className="mt-6 text-green-600 font-semibold">
                    <p>Dr. H. Ahmad Fauzi, M.Pd</p>
                    <p className="text-sm text-gray-600">Kepala Sekolah</p>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Statistik */}
      <section className="py-16 px-4 bg-white">
        <div className="max-w-7xl mx-auto">
          <h2 className="text-3xl font-bold text-center mb-12 text-gray-800">
            Statistik Sekolah
          </h2>
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6">
            <StatCard
              icon={<Users className="h-8 w-8" />}
              value="50+"
              label="Guru Profesional"
              color="bg-yellow-100 text-yellow-700"
            />
            <StatCard
              icon={<GraduationCap className="h-8 w-8" />}
              value="1000+"
              label="Siswa Aktif"
              color="bg-green-100 text-green-700"
            />
            <StatCard
              icon={<BookOpen className="h-8 w-8" />}
              value="36"
              label="Kelas"
              color="bg-yellow-100 text-yellow-700"
            />
            <StatCard
              icon={<Award className="h-8 w-8" />}
              value="20+"
              label="Mata Pelajaran"
              color="bg-green-100 text-green-700"
            />
          </div>
        </div>
      </section>

      {/* Keunggulan */}
      <section className="py-16 px-4 bg-gradient-to-br from-gray-50 to-white">
        <div className="max-w-7xl mx-auto">
          <h2 className="text-3xl font-bold text-center mb-12 text-gray-800">
            Keunggulan Kami
          </h2>
          <div className="grid md:grid-cols-3 gap-8">
            <FeatureCard
              icon={<TrendingUp className="h-12 w-12" />}
              title="Prestasi Akademik"
              description="Mencetak siswa berprestasi dalam akademik dengan kurikulum yang terstruktur dan metode pembelajaran modern."
              color="text-yellow-600 bg-yellow-50"
            />
            <FeatureCard
              icon={<Users className="h-12 w-12" />}
              title="Guru Profesional"
              description="Didukung oleh tenaga pendidik yang berpengalaman, bersertifikasi, dan berdedikasi tinggi."
              color="text-green-600 bg-green-50"
            />
            <FeatureCard
              icon={<Clock className="h-12 w-12" />}
              title="Fasilitas Lengkap"
              description="Fasilitas pendukung pembelajaran yang modern dan nyaman untuk mendukung aktivitas belajar siswa."
              color="text-yellow-600 bg-yellow-50"
            />
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 px-4 bg-gradient-to-r from-green-500 to-green-600">
        <div className="max-w-4xl mx-auto text-center text-white">
          <h2 className="text-3xl font-bold mb-6">
            Bergabunglah Bersama Kami!
          </h2>
          <p className="text-xl mb-8">
            Daftarkan anak Anda untuk mendapatkan pendidikan terbaik di Sekolah Unggulan.
          </p>
          <Link href="#profil">
            <Button size="lg" className="bg-white text-green-600 hover:bg-yellow-50 text-lg px-12 py-6">
              Hubungi Kami
            </Button>
          </Link>
        </div>
      </section>

      {/* Profil Section */}
      <section id="profil" className="py-16 px-4 bg-white">
        <div className="max-w-7xl mx-auto">
          <h2 className="text-3xl font-bold text-center mb-12 text-gray-800">
            Profil Sekolah
          </h2>
          <div className="grid md:grid-cols-2 gap-8">
            {/* Visi */}
            <Card className="shadow-lg border-2 border-yellow-200">
              <CardHeader>
                <CardTitle className="text-2xl text-yellow-700">Visi</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-gray-700 leading-relaxed text-lg italic">
                  "Menjadi lembaga pendidikan unggul yang mencetak generasi berkarakter, cerdas, dan berprestasi berlandaskan iman dan taqwa."
                </p>
              </CardContent>
            </Card>

            {/* Misi */}
            <Card className="shadow-lg border-2 border-green-200">
              <CardHeader>
                <CardTitle className="text-2xl text-green-700">Misi</CardTitle>
              </CardHeader>
              <CardContent>
                <ul className="space-y-3 text-gray-700">
                  <li className="flex items-start">
                    <span className="text-green-600 mr-2">•</span>
                    <span>Menyelenggarakan pendidikan berkualitas yang mengintegrasikan ilmu pengetahuan dan nilai-nilai agama.</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-green-600 mr-2">•</span>
                    <span>Mengembangkan potensi siswa secara optimal melalui kegiatan kurikuler dan ekstrakurikuler.</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-green-600 mr-2">•</span>
                    <span>Membentuk karakter siswa yang beretika, disiplin, dan berjiwa kepemimpinan.</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-green-600 mr-2">•</span>
                    <span>Meningkatkan kualitas tenaga pendidik dan kependidikan secara berkelanjutan.</span>
                  </li>
                </ul>
              </CardContent>
            </Card>

            {/* Sejarah Singkat */}
            <Card className="shadow-lg border-2 border-yellow-200 md:col-span-2">
              <CardHeader>
                <CardTitle className="text-2xl text-yellow-700">Sejarah Singkat</CardTitle>
              </CardHeader>
              <CardContent>
                <div className="text-gray-700 leading-relaxed space-y-4">
                  <p>
                    Sekolah Unggulan didirikan pada tahun 2005 dengan semangat untuk menyediakan pendidikan berkualitas bagi masyarakat. 
                    Berawal dari 12 siswa dan 5 guru, kami terus berkembang dan kini telah menjadi salah satu lembaga pendidikan terpercaya di daerah ini.
                  </p>
                  <p>
                    Selama lebih dari 15 tahun, kami telah meluluskan ribuan siswa yang kini telah sukses di berbagai bidang. 
                    Keberhasilan ini tidak lepas dari komitmen kami untuk terus meningkatkan kualitas pendidikan dan fasilitas yang kami miliki.
                  </p>
                  <p>
                    Tahun 2020, kami meraih predikat Sekolah Adiwiyata dan Tahun 2023 meraih predikat Sekolah Penggerak. 
                    Ini adalah bukti nyata komitmen kami terhadap pendidikan berkualitas dan kepedulian terhadap lingkungan.
                  </p>
                </div>
              </CardContent>
            </Card>

            {/* Kontak */}
            <Card className="shadow-lg border-2 border-green-200 md:col-span-2">
              <CardHeader>
                <CardTitle className="text-2xl text-green-700">Kontak</CardTitle>
              </CardHeader>
              <CardContent>
                <div className="grid md:grid-cols-2 gap-6">
                  <div>
                    <h4 className="font-semibold text-lg mb-4 text-gray-800">Informasi Kontak</h4>
                    <div className="space-y-3 text-gray-700">
                      <p><strong>Alamat:</strong> Jl. Pendidikan No. 123, Kota, Indonesia</p>
                      <p><strong>Telepon:</strong> (021) 1234-5678</p>
                      <p><strong>Fax:</strong> (021) 1234-5679</p>
                      <p><strong>Email:</strong> info@sekolahunggulan.sch.id</p>
                      <p><strong>Website:</strong> www.sekolahunggulan.sch.id</p>
                    </div>
                  </div>
                  <div>
                    <h4 className="font-semibold text-lg mb-4 text-gray-800">Jam Operasional</h4>
                    <div className="space-y-2 text-gray-700">
                      <p><strong>Senin - Kamis:</strong> 07.00 - 15.00 WIB</p>
                      <p><strong>Jumat:</strong> 07.00 - 11.30 WIB</p>
                      <p><strong>Sabtu:</strong> 07.00 - 12.00 WIB (Ekstrakurikuler)</p>
                      <p><strong>Minggu:</strong> Libur</p>
                    </div>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Guru Section */}
      <section id="guru" className="py-16 px-4 bg-gray-50">
        <div className="max-w-7xl mx-auto">
          <h2 className="text-3xl font-bold text-center mb-12 text-gray-800">
            Daftar Guru
          </h2>
          <Card className="shadow-xl">
            <CardContent className="p-6 overflow-x-auto">
              <table className="w-full">
                <thead>
                  <tr className="bg-gradient-to-r from-yellow-400 to-green-500 text-white">
                    <th className="px-4 py-3 text-left font-semibold">No</th>
                    <th className="px-4 py-3 text-left font-semibold">Nama Guru</th>
                    <th className="px-4 py-3 text-left font-semibold">Mata Pelajaran</th>
                    <th className="px-4 py-3 text-left font-semibold">Kontak</th>
                  </tr>
                </thead>
                <tbody>
                  {[
                    { name: 'Dra. Siti Aminah', mapel: 'Bahasa Indonesia', kontak: '081234567890' },
                    { name: 'Budi Santoso, S.Pd', mapel: 'Matematika', kontak: '081234567891' },
                    { name: 'Ratna Sari, S.Pd', mapel: 'IPA', kontak: '081234567892' },
                    { name: 'Agus Setiawan, S.Pd', mapel: 'Bahasa Inggris', kontak: '081234567893' },
                    { name: 'Dewi Kartika, S.Pd', mapel: 'IPS', kontak: '081234567894' },
                  ].map((guru, index) => (
                    <tr key={index} className={index % 2 === 0 ? 'bg-white' : 'bg-gray-50'}>
                      <td className="px-4 py-3 text-gray-700">{index + 1}</td>
                      <td className="px-4 py-3 font-medium text-gray-800">{guru.name}</td>
                      <td className="px-4 py-3 text-gray-700">{guru.mapel}</td>
                      <td className="px-4 py-3 text-gray-700">{guru.kontak}</td>
                    </tr>
                  ))}
                </tbody>
              </table>
              <p className="text-sm text-gray-500 mt-4 italic">
                * Daftar lengkap dapat diakses melalui login admin
              </p>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Siswa Section */}
      <section id="siswa" className="py-16 px-4 bg-white">
        <div className="max-w-7xl mx-auto">
          <h2 className="text-3xl font-bold text-center mb-12 text-gray-800">
            Data Siswa
          </h2>
          <Card className="shadow-xl">
            <CardContent className="p-6 overflow-x-auto">
              <table className="w-full">
                <thead>
                  <tr className="bg-gradient-to-r from-green-500 to-yellow-400 text-white">
                    <th className="px-4 py-3 text-left font-semibold">No</th>
                    <th className="px-4 py-3 text-left font-semibold">NISN</th>
                    <th className="px-4 py-3 text-left font-semibold">Nama</th>
                    <th className="px-4 py-3 text-left font-semibold">Kelas</th>
                    <th className="px-4 py-3 text-left font-semibold">Status</th>
                  </tr>
                </thead>
                <tbody>
                  {[
                    { nisn: '1234567890', nama: 'Ahmad Rizky', kelas: 'X IPA 1', status: 'Aktif' },
                    { nisn: '1234567891', nama: 'Putri Ayu', kelas: 'X IPA 2', status: 'Aktif' },
                    { nisn: '1234567892', nama: 'Budi Pratama', kelas: 'XI IPA 1', status: 'Aktif' },
                    { nisn: '1234567893', nama: 'Siti Rahayu', kelas: 'XI IPS 1', status: 'Aktif' },
                    { nisn: '1234567894', nama: 'Dewi Kartika', kelas: 'XII IPA 1', status: 'Aktif' },
                  ].map((siswa, index) => (
                    <tr key={index} className={index % 2 === 0 ? 'bg-white' : 'bg-gray-50'}>
                      <td className="px-4 py-3 text-gray-700">{index + 1}</td>
                      <td className="px-4 py-3 text-gray-700">{siswa.nisn}</td>
                      <td className="px-4 py-3 font-medium text-gray-800">{siswa.nama}</td>
                      <td className="px-4 py-3 text-gray-700">{siswa.kelas}</td>
                      <td className="px-4 py-3">
                        <span className="px-2 py-1 bg-green-100 text-green-700 rounded-full text-sm">
                          {siswa.status}
                        </span>
                      </td>
                    </tr>
                  ))}
                </tbody>
              </table>
              <p className="text-sm text-gray-500 mt-4 italic">
                * Data lengkap dan sensitif dapat diakses melalui login admin
              </p>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Rekap Siswa Section */}
      <section id="rekap" className="py-16 px-4 bg-gray-50">
        <div className="max-w-7xl mx-auto">
          <h2 className="text-3xl font-bold text-center mb-12 text-gray-800">
            Rekapitulasi Data Siswa
          </h2>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            <RekapCard
              title="Jumlah per Kelas"
              data={[
                { label: 'X IPA 1', value: '32' },
                { label: 'X IPA 2', value: '30' },
                { label: 'X IPS 1', value: '28' },
                { label: 'XI IPA 1', value: '29' },
                { label: 'XI IPS 1', value: '27' },
              ]}
              color="from-yellow-400 to-yellow-500"
            />
            <RekapCard
              title="Jumlah per Angkatan"
              data={[
                { label: 'Angkatan 2024', value: '90' },
                { label: 'Angkatan 2023', value: '88' },
                { label: 'Angkatan 2022', value: '85' },
              ]}
              color="from-green-400 to-green-500"
            />
            <RekapCard
              title="Jenis Kelamin"
              data={[
                { label: 'Laki-laki', value: '450' },
                { label: 'Perempuan', value: '550' },
              ]}
              color="from-yellow-400 to-green-500"
            />
          </div>

          <Card className="shadow-xl mt-8">
            <CardHeader>
              <CardTitle className="text-2xl text-gray-800">Ringkasan Statistik</CardTitle>
            </CardHeader>
            <CardContent>
              <div className="grid md:grid-cols-4 gap-4">
                <div className="text-center p-4 bg-gradient-to-br from-yellow-100 to-yellow-200 rounded-lg">
                  <div className="text-3xl font-bold text-yellow-700 mb-1">1000</div>
                  <div className="text-sm text-gray-600">Total Siswa</div>
                </div>
                <div className="text-center p-4 bg-gradient-to-br from-green-100 to-green-200 rounded-lg">
                  <div className="text-3xl font-bold text-green-700 mb-1">950</div>
                  <div className="text-sm text-gray-600">Siswa Aktif</div>
                </div>
                <div className="text-center p-4 bg-gradient-to-br from-yellow-100 to-yellow-200 rounded-lg">
                  <div className="text-3xl font-bold text-yellow-700 mb-1">40</div>
                  <div className="text-sm text-gray-600">Siswa Lulus</div>
                </div>
                <div className="text-center p-4 bg-gradient-to-br from-green-100 to-green-200 rounded-lg">
                  <div className="text-3xl font-bold text-green-700 mb-1">10</div>
                  <div className="text-sm text-gray-600">Siswa Keluar</div>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Katrol Nilai Section */}
      <section id="katrol" className="py-16 px-4 bg-white">
        <div className="max-w-4xl mx-auto">
          <Card className="shadow-xl border-2 border-yellow-200">
            <CardHeader>
              <CardTitle className="text-3xl text-center text-yellow-700">Katrol Nilai</CardTitle>
            </CardHeader>
            <CardContent className="text-center py-12">
              <div className="bg-gradient-to-br from-yellow-50 to-green-50 rounded-lg p-8">
                <GraduationCap className="h-24 w-24 mx-auto mb-6 text-green-600" />
                <h3 className="text-2xl font-bold text-gray-800 mb-4">Sistem Katrol Nilai</h3>
                <p className="text-gray-600 mb-6 max-w-2xl mx-auto">
                  Fitur ini sedang dalam pengembangan. Nantikan update untuk sistem penilaian dan pelaporan hasil belajar siswa.
                </p>
                <div className="text-sm text-gray-500">
                  <p>Fitur yang akan tersedia:</p>
                  <ul className="mt-2 space-y-1">
                    <li>• Input nilai harian</li>
                    <li>• Input nilai ulangan</li>
                    <li>• Input nilai ujian</li>
                    <li>• Rapor siswa</li>
                    <li>• Statistik nilai per mata pelajaran</li>
                  </ul>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Catatan Wali Kelas Section */}
      <section id="catatan" className="py-16 px-4 bg-gray-50">
        <div className="max-w-7xl mx-auto">
          <h2 className="text-3xl font-bold text-center mb-12 text-gray-800">
            Catatan Wali Kelas
          </h2>
          <Card className="shadow-xl">
            <CardContent className="p-6 overflow-x-auto">
              <table className="w-full">
                <thead>
                  <tr className="bg-gradient-to-r from-green-500 to-yellow-400 text-white">
                    <th className="px-4 py-3 text-left font-semibold">No</th>
                    <th className="px-4 py-3 text-left font-semibold">Judul Catatan</th>
                    <th className="px-4 py-3 text-left font-semibold">Kelas</th>
                    <th className="px-4 py-3 text-left font-semibold">Tanggal</th>
                    <th className="px-4 py-3 text-left font-semibold">Aksi</th>
                  </tr>
                </thead>
                <tbody>
                  {[
                    { judul: 'Evaluasi Perkembangan Siswa', kelas: 'X IPA 1', tanggal: '2024-01-15' },
                    { judul: 'Hasil Evaluasi Tengah Semester', kelas: 'XI IPA 1', tanggal: '2024-01-10' },
                    { judul: 'Catatan Perkembangan Akademik', kelas: 'XII IPA 1', tanggal: '2024-01-05' },
                    { judul: 'Laporan Keaktifan Siswa', kelas: 'X IPS 1', tanggal: '2024-01-03' },
                    { judul: 'Rekap Absensi', kelas: 'XI IPS 1', tanggal: '2024-01-01' },
                  ].map((catatan, index) => (
                    <tr key={index} className={index % 2 === 0 ? 'bg-white' : 'bg-gray-50'}>
                      <td className="px-4 py-3 text-gray-700">{index + 1}</td>
                      <td className="px-4 py-3 font-medium text-gray-800">{catatan.judul}</td>
                      <td className="px-4 py-3 text-gray-700">{catatan.kelas}</td>
                      <td className="px-4 py-3 text-gray-700">{catatan.tanggal}</td>
                      <td className="px-4 py-3">
                        <Button size="sm" variant="outline" className="bg-green-50 text-green-700 hover:bg-green-100">
                          Unduh
                        </Button>
                      </td>
                    </tr>
                  ))}
                </tbody>
              </table>
              <p className="text-sm text-gray-500 mt-4 italic">
                * Catatan lengkap dapat diakses dan diunduh melalui login admin
              </p>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Download Section */}
      <section id="download" className="py-16 px-4 bg-white">
        <div className="max-w-7xl mx-auto">
          <h2 className="text-3xl font-bold text-center mb-12 text-gray-800">
            Download
          </h2>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            {[
              { judul: 'Panduan Pendaftaran Siswa Baru', type: 'PDF', ukuran: '2.5 MB' },
              { judul: 'Formulir Data Diri Siswa', type: 'PDF', ukuran: '1.8 MB' },
              { judul: 'Kalender Akademik 2024-2025', type: 'PDF', ukuran: '3.2 MB' },
              { judul: 'Peraturan Sekolah', type: 'PDF', ukuran: '1.5 MB' },
              { judul: 'Panduan Pembayaran SPP', type: 'PDF', ukuran: '2.0 MB' },
              { judul: 'Formulir Izin Sakit', type: 'PDF', ukuran: '0.5 MB' },
            ].map((file, index) => (
              <Card key={index} className="shadow-lg hover:shadow-2xl transition-all duration-300 border-2 border-green-100">
                <CardContent className="p-6">
                  <div className="flex items-start justify-between mb-4">
                    <div className="bg-gradient-to-br from-yellow-400 to-green-500 rounded-lg p-3">
                      <BookOpen className="h-6 w-6 text-white" />
                    </div>
                    <span className="px-2 py-1 bg-green-100 text-green-700 rounded-full text-xs font-medium">
                      {file.type}
                    </span>
                  </div>
                  <h3 className="font-semibold text-gray-800 mb-2">{file.judul}</h3>
                  <p className="text-sm text-gray-500 mb-4">Ukuran: {file.ukuran}</p>
                  <Button className="w-full bg-gradient-to-r from-green-500 to-green-600 hover:from-green-600 hover:to-green-700">
                    Download
                  </Button>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Login Section */}
      <section id="login" className="py-16 px-4 bg-gray-50">
        <div className="max-w-md mx-auto">
          <Card className="shadow-xl border-2 border-green-200">
            <CardHeader>
              <CardTitle className="text-3xl text-center text-green-700">Login Admin</CardTitle>
              <CardDescription className="text-center">
                Masuk untuk mengakses dashboard admin
              </CardDescription>
            </CardHeader>
            <CardContent>
              <form className="space-y-4">
                <div>
                  <label className="block text-sm font-medium text-gray-700 mb-2">
                    Username
                  </label>
                  <Input
                    type="text"
                    placeholder="Masukkan username"
                    className="border-2 focus:border-green-500"
                  />
                </div>
                <div>
                  <label className="block text-sm font-medium text-gray-700 mb-2">
                    Password
                  </label>
                  <Input
                    type="password"
                    placeholder="Masukkan password"
                    className="border-2 focus:border-green-500"
                  />
                </div>
                <Button className="w-full bg-gradient-to-r from-green-500 to-green-600 hover:from-green-600 hover:to-green-700 text-white">
                  Login
                </Button>
              </form>
              <p className="text-sm text-center text-gray-500 mt-4">
                <em>Default admin: username "admin", password "admin123"</em>
              </p>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Section Identifiers */}
      <section id="profil-section-identifier" />
      <section id="guru-section-identifier" />
      <section id="siswa-section-identifier" />
      <section id="rekap-section-identifier" />
      <section id="katrol-section-identifier" />
      <section id="catatan-section-identifier" />
      <section id="download-section-identifier" />
      <section id="login-section-identifier" />
    </div>
  )
}

function StatCard({ icon, value, label, color }: any) {
  return (
    <Card className={`${color} border-2 hover:shadow-xl transition-all duration-300`}>
      <CardContent className="p-6 text-center">
        <div className="flex justify-center mb-4">
          {icon}
        </div>
        <div className="text-3xl font-bold mb-2">{value}</div>
        <div className="text-sm font-medium">{label}</div>
      </CardContent>
    </Card>
  )
}

function FeatureCard({ icon, title, description, color }: any) {
  return (
    <Card className="shadow-lg hover:shadow-2xl transition-all duration-300 border-2 border-green-100">
      <CardHeader>
        <div className={`${color} w-20 h-20 rounded-full flex items-center justify-center mb-4`}>
          {icon}
        </div>
        <CardTitle className="text-xl">{title}</CardTitle>
      </CardHeader>
      <CardContent>
        <p className="text-gray-600 leading-relaxed">{description}</p>
      </CardContent>
    </Card>
  )
}

function RekapCard({ title, data, color }: any) {
  return (
    <Card className="shadow-xl border-2">
      <CardHeader className={`bg-gradient-to-r ${color}`}>
        <CardTitle className="text-white text-lg">{title}</CardTitle>
      </CardHeader>
      <CardContent className="p-4">
        <ul className="space-y-3">
          {data.map((item: any, index: number) => (
            <li key={index} className="flex justify-between items-center p-2 bg-gray-50 rounded">
              <span className="text-gray-700 font-medium">{item.label}</span>
              <span className="bg-gradient-to-r from-yellow-400 to-green-500 text-white px-3 py-1 rounded-full font-bold text-sm">
                {item.value}
              </span>
            </li>
          ))}
        </ul>
      </CardContent>
    </Card>
  )
}
