import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import { Toaster } from "@/components/ui/toaster";
import Navbar from "@/components/layout/navbar";
import Footer from "@/components/layout/footer";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "Sistem Informasi Sekolah Unggulan",
  description: "Aplikasi sistem informasi akademik sekolah - Data Guru, Siswa, Kelas, dan Mata Pelajaran",
  keywords: ["sekolah", "pendidikan", "sistem informasi", "akademik", "guru", "siswa"],
  authors: [{ name: "Sekolah Unggulan" }],
  openGraph: {
    title: "Sistem Informasi Sekolah Unggulan",
    description: "Sistem informasi akademik terpadu",
    type: "website",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="id" suppressHydrationWarning>
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased bg-white min-h-screen flex flex-col`}
      >
        <Navbar />
        <main className="flex-grow">
          {children}
        </main>
        <Footer />
        <Toaster />
      </body>
    </html>
  );
}
