import { NextResponse } from 'next/server'
import * as xlsx from 'xlsx'

// GET - Download template Excel data siswa
export async function GET() {
  try {
    // Header kolom untuk template
    const headers = [
      'Induk',
      'NISN',
      'Tahun Masuk',
      'NIS Lokal',
      'Nama',
      'L/P',
      'NIK',
      'Nomor KK',
      'Agama',
      'Tempat Lahir',
      'Tanggal Lahir',
      'Anak Ke',
      'Status Keluarga',
      'Telepon',
      'Alamat',
      'Kelas',
      'Status Siswa',
      'Nama Ayah',
      'NIK Ayah',
      'TTL Ayah',
      'Pendidikan Ayah',
      'Pekerjaan Ayah',
      'Penghasilan Ayah',
      'Nama Ibu',
      'NIK Ibu',
      'TTL Ibu',
      'Pendidikan Ibu',
      'Pekerjaan Ibu',
      'Penghasilan Ibu',
      'Alamat Ortu'
    ]

    // Buat worksheet
    const worksheet = xlsx.utils.aoa_to_sheet([headers])

    // Buat workbook
    const workbook = xlsx.utils.book_new()
    xlsx.utils.book_append_sheet(workbook, worksheet, 'Data Siswa')

    // Convert ke buffer
    const buffer = xlsx.write(workbook, { type: 'buffer', bookType: 'xlsx' })

    // Return file
    return new NextResponse(buffer as any, {
      status: 200,
      headers: {
        'Content-Type': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'Content-Disposition': 'attachment; filename="template_data_siswa.xlsx"'
      }
    })
  } catch (error) {
    console.error('Generate template error:', error)
    return NextResponse.json(
      { error: 'Terjadi kesalahan saat generate template' },
      { status: 500 }
    )
  }
}
