import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'

// GET - Ambil semua data guru
export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const search = searchParams.get('search')

    const guruList = await db.guru.findMany({
      where: search
        ? {
            OR: [
              { nama: { contains: search } },
              { mataPelajaran: { contains: search } },
              { nip: { contains: search } }
            ]
          }
        : undefined,
      orderBy: { createdAt: 'desc' }
    })

    return NextResponse.json({ success: true, data: guruList })
  } catch (error) {
    console.error('Get guru error:', error)
    return NextResponse.json(
      { error: 'Terjadi kesalahan saat mengambil data guru' },
      { status: 500 }
    )
  }
}

// POST - Tambah guru baru
export async function POST(request: NextRequest) {
  try {
    const body = await request.json()
    const { nip, nama, mataPelajaran, kontak, alamat } = body

    if (!nama || !mataPelajaran) {
      return NextResponse.json(
        { error: 'Nama dan mata pelajaran harus diisi' },
        { status: 400 }
      )
    }

    const guru = await db.guru.create({
      data: {
        nip,
        nama,
        mataPelajaran,
        kontak,
        alamat
      }
    })

    return NextResponse.json({ success: true, data: guru }, { status: 201 })
  } catch (error) {
    console.error('Create guru error:', error)
    return NextResponse.json(
      { error: 'Terjadi kesalahan saat menambah guru' },
      { status: 500 }
    )
  }
}
